# Début programme de démonstration des entrées analogique (Console+fonction de rappel)
# Ce programme mesure et affiche A0 dans la console Python.

# Ce programme est une variante de LectureAnalogiqueConsole.py .
# Ce programme utilise une méthode de lecture automatique via fonction de rappel.

from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)
#plugUno = Arduino(input("Saisir le port de communication COM1, COM2, COM3 .... :"))

################################
# Configuration des E/S
################################
brocheA0 = plugUno.get_pin('a:0:i')
# -> a  : signifie mode analogique
# -> 0  : numéro de la broche (0/1/2/3/4)
# -> i  : mode entré (est seule mode offert part Plug'Uno)


# Active le mécanisme de récuperation des différents états des E/S de Plug'Uno ;
# Définit la fréquence d'échantillonnage.
plugUno.samplingOn( 20 ) # interval de mesure : 20 ms -> 50 Hz

# Définit la fonction qui sera appelé a chaque mesure ADC
compteurMesure = 0
def fonctionDeRappelLectureA0(valeurA0):
    global compteurMesure
    print(
        "("+str(compteurMesure)+") "
        "A0 :",
        valeurA0,
        "/1 (soit ",
        "{:.2f}".format( valeurA0 * 5.0 ),
        "V si VCC=5V)"
    )
    compteurMesure += 1

input(
    "\nLe programme est pret a mesurer l'entree analogique A0.\n"
    "Appuyer sur \"ENTRER\" pour demarrer.\n"
    "L'acquisition prendra fin au bout de 5 secondes"
)

# Associe la fonction de rappel définie ci-dessus a l'énement de mise a jour ADC
brocheA0.register_callback(fonctionDeRappelLectureA0)

sleep(5)

# Fermer la connexion à Plug'Uno avant de quitter.
plugUno.exit()

# Termine l'éxecution du programme Python.
#exit()

# Fin programme de démonstration des entrées analogique (Console+fonction de rappel)
